﻿<# 2021.02.21
WaaS Info Script Phase 1 of 2.  
Phase 1 is at start of TS, grabs basic info and writes to registry.

  IPU Keys:
   IPULastRun
   IPUExecutionTypeUser
   IPUUserLoggedOn
   IPUDeploymentID
   IPUPackageID - Required for OSUninstall
   IPUAttempts - Removed - Added to Part 2, we don't want to record IPUAttempts if it doesn't make it past Pre-Flight
   IPUUserAccount
   IPUPendingReboot
   IPUBuildFrom
   WaaS_Stage - Removed - Added to Part 2, we don't want to record Stage if it doesn't make it past Pre-Flight
   IPUSelfService (If AdvertID = AdvertID of the Self Self Service Deployment, Set to True)

    Changes:
    2021.06.08 - Added Logging into SMSTSlog
    2021.06.15 - Added logged on users even via RDP
#>


#Setup TS Environment
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
}
catch
{
	Write-Verbose "Not running in a task sequence."
}

if ($tsenv)
    {

    $tsBuild = $tsenv.Value("WaaS_UpgradeBuild") #Get Build Number from TS Variable.
    $registryPath = "HKLM:\$($tsenv.Value("RegistryPath"))\$tsBuild" #Sets Registry Location
    
    $ScriptVer = "21.06.08"
    Write-Output "-----------------------------------------"
    Write-Output "Starting - Inventory IPU Start Results Script: $ScriptVer "
    
    #Create Registry Keys if needed
    if ( -not ( test-path $registryPath ) ) { 
        new-item -ItemType directory -path $registryPath -force -erroraction SilentlyContinue | out-null
    }
    #Writes the Start Time to a Key in the Parent (WaaS) with the name of the TS, so we can keep track of when we've run which TS.
    New-ItemProperty -Path "HKLM:\$($tsenv.Value("RegistryPath"))" -Name $tsenv.Value("_SMSTSPackageName") -Value $tsenv.Value("SMSTS_StartTSTime") -Force | Out-Null
    Write-Output " Writing to Parent WaaS Key: $($tsenv.Value("_SMSTSPackageName")) value: $($tsenv.Value("SMSTS_StartTSTime"))"

    #Writes Into to the WaaS\Build Number\ Key
    New-ItemProperty -Path $registryPath -Name "IPULastRun" -Value $TSEnv.Value('SMSTS_StartTSTime') -Force | Out-Null
    Write-Output " Writing IPULastRun Value to $($TSEnv.Value('SMSTS_StartTSTime'))"
    New-ItemProperty -Path $registryPath -Name "IPUDeploymentID" -Value $TSEnv.Value('_SMSTSAdvertID') -Force | Out-Null
    Write-Output " Writing IPUDeploymentID Value to $($TSEnv.Value('_SMSTSAdvertID'))"
    New-ItemProperty -Path $registryPath -Name "IPUPackageID" -Value $TSEnv.Value('_SMSTSPackageID') -Force | Out-Null
    Write-Output " Writing IPUPackageID Value to $($TSEnv.Value('_SMSTSPackageID'))"

    #Creates the IPURebootPending Value, for those curious if a pending reboot might affect upgrades
    New-ItemProperty -Path $registryPath -Name "IPURebootPending" -Value (Invoke-WmiMethod -Namespace 'root\ccm\ClientSDK' -Class CCM_ClientUtilities -Name DetermineIfRebootPending).RebootPending -Force | Out-Null

    if ($TSEnv.Value('_SMSTSAdvertID') -eq $TSEnv.Value('SelfServiceDeploymentID'))
        {
        New-ItemProperty -Path $registryPath -Name "IPUSelfService" -Value "True" -Force | Out-Null
        Write-Output " Writing IPUSelfService Value to True"
        }    
    #User Info | TS Started:
    New-ItemProperty -Path $registryPath -Name "IPUExecutionTypeUser" -Value $tsenv.Value("_SMSTSUserStarted") -Force | Out-Null
    Write-Output " Writing IPUExecutionTypeUser Value to $($TSEnv.Value('_SMSTSUserStarted'))"
    #IF Explorer Running, Get Owner Name and ASSUME they are logged on:
    if (Get-Process -Name explorer -ErrorAction SilentlyContinue){
        New-ItemProperty -Path $registryPath -Name "IPUUserLoggedOn" -Value "TRUE" -Force | Out-Null
        Write-Output " Writing IPUUserLoggedOn Value to TRUE"
        $Users = (Get-Process -Name explorer -IncludeUserName).UserName
        foreach ($User in $Users)
            {
            $UserAccount = ($User).split("\")[1]
            $LoggedOnUsers += "$($UserAccount), "
            }
        $LoggedOnUsers = $LoggedOnUsers.Substring(0,$LoggedOnUsers.Length-2)
        #Stole IPUUserAccount from below to try new idea
        New-ItemProperty -Path $registryPath -Name IPUUserAccount -Value $LoggedOnUsers -Force | Out-Null
        Write-Output " Writing IPUUserAccount Value to $LoggedOnUsers"
        }
    else {
        New-ItemProperty -Path $registryPath -Name "IPUUserLoggedOn" -Value "FALSE" -Force | Out-Null
        Write-Output " Writing IPUUserLoggedOn Value to FALSE"
        Remove-ItemProperty -Path $registryPath -Name "IPUUserAccount" -Force -ErrorAction SilentlyContinue
        }
    
    <#Grabs User Name of the user Logged on. - Replaced with new code just above.
    if ($tsenv.Value("_SMSTSUserStarted") -eq "True")
        {
        $regexa = '.+Domain="(.+)",Name="(.+)"$' 
        $regexd = '.+LogonId="(\d+)"$' 
 
        $logon_sessions = @(gwmi win32_logonsession -ComputerName $env:COMPUTERNAME) 
        $logon_users = @(gwmi win32_loggedonuser -ComputerName $env:COMPUTERNAME) 
 
        $session_user = @{} 
 
        $logon_users |% { $_.antecedent -match $regexa > $nul ;$username = $matches[2] ;$_.dependent -match $regexd > $nul ;$session = $matches[1] ;$session_user[$session] += $username } 
 
 
        $currentUser = $logon_sessions |%{ 
            $loggedonuser = New-Object -TypeName psobject 
            $loggedonuser | Add-Member -MemberType NoteProperty -Name "User" -Value $session_user[$_.logonid] 
            $loggedonuser | Add-Member -MemberType NoteProperty -Name "Type" -Value $_.logontype
            $loggedonuser | Add-Member -MemberType NoteProperty -Name "Auth" -Value $_.authenticationpackage 

            ($loggedonuser  | where {$_.Type -eq "2" -and $_.Auth -eq "Kerberos"}).User 
            } 
        $currentUser = $currentUser | select -Unique
        Write-Host $CurrentUser
        New-ItemProperty -Path $registryPath -Name IPUUserAccount -Value $CurrentUser -Force | Out-Null
        Write-Output " Writing IPUUserAccount Value to $CurrentUser"
        }
    #>

    #Add Build Record Info so you know which Build of OS was Upgraded From
    if ((Get-ItemProperty -Path $registryPath -Name "IPUBuildFrom" -ErrorAction SilentlyContinue) -eq $null)
        {
        $UBR = (Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' CurrentBuildNumber)+'.'+(Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' UBR)
        New-ItemProperty -Path $registryPath -Name "IPUBuildFrom" -Value $UBR -Force | Out-Null
        Write-Output " Writing IPUBuildFrom Value to $UBR"
        }
    
    Write-Output "Completed - Inventory IPU Start Results Script: $ScriptVer "
    Write-Output "-----------------------------------------"

    
    }